<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Section extends Model
{
    protected $table = 'sections';
    protected $primaryKey = 'Section_id';
    public $timestamps = true;

    protected $fillable = [
        'Course_id',
        'Title',
        'Description',
        'Order',
        'Metadata',
    ];

    protected $casts = [
        'Created_at' => 'datetime',
        'Updated_at' => 'datetime',
        'Order' => 'integer',
        'Metadata' => 'array',
    ];

    /**
     * Get the course that owns the section.
     */
    public function course(): BelongsTo
    {
        return $this->belongsTo(Course::class, 'Course_id', 'Course_id');
    }

    /**
     * Get the lessons for the section.
     */
    public function lessons(): HasMany
    {
        return $this->hasMany(Lesson::class, 'Section_id', 'Section_id');
    }
}
